import { ContainerConfig, ExtendedFieldConfig } from '../../models';

import { CardsListContainer, CardsListContainerControlProps } from './CardsListContainer';

export { CardsListContainer } from './CardsListContainer';

export interface CardsListContainerConfig<FV, V> extends ContainerConfig<FV, V> {
   addButtonText?: CardsListContainerControlProps['addButtonText'];
   cardProps?: CardsListContainerControlProps['cardProps'];
   getCardTitle: CardsListContainerControlProps['getCardTitle'];
   keepAtLeastOne?: CardsListContainerControlProps['keepAtLeastOne'];
}

export function cards<FormValue = any, V = any[]>({
   fieldLayoutProps,
   key,
   label,
   name,
   ...controlProps
}: CardsListContainerConfig<FormValue, V>): ExtendedFieldConfig<FormValue, V, CardsListContainerControlProps> {
   return {
      ...fieldLayoutProps,
      as: CardsListContainer,
      controlProps,
      key,
      label,
      name,
   };
}
