import { action } from '@storybook/addon-actions';
import { Meta, Story } from '@storybook/react';
import { Formik } from 'formik';
import * as React from 'react';

import { DeclarativeFields, DevFormValues } from '../../components';
import { InputField } from '../../fields';
import { ExtendedFieldConfig } from '../../models';

import { list, ListContainer, ListContainerConfig } from './index';

const formValues = {
   name: 'Tema',
   age: 22,
   skills: ['angular', 'react'],
};

type FormValue = typeof formValues;

const internalFields: ExtendedFieldConfig<FormValue>[] = [
   { as: InputField, name: 'name', label: 'Name' },
   { as: InputField, name: 'age', label: 'Age', controlProps: { type: 'number' } },
];

const skillFields = [
   {
      as: InputField,
      name: '',
      label: null,
      placeholder: 'Skill',
      controlProps: { hasClear: false },
   },
];

type StoryProps = Omit<ListContainerConfig<FormValue, any[]>, 'key' | 'name' | 'fields'>;

const DeclarativeTemplate: Story<StoryProps> = config => {
   const fields: ExtendedFieldConfig<FormValue>[] = [
      ...internalFields,
      list({
         ...config,
         addButtonText: config.addButtonText,
         fields: skillFields,
         keepAtLeastOne: config.keepAtLeastOne,
         key: 'skills',
         name: 'skills',
      }),
   ];

   return (
      <Formik initialValues={formValues} onSubmit={action('onSubmit')}>
         {() => (
            <>
               <DeclarativeFields configs={fields} />
               <DevFormValues open={true} />
            </>
         )}
      </Formik>
   );
};

const ReactTemplate: Story<StoryProps> = config => (
   <Formik initialValues={formValues} onSubmit={action('onSubmit')}>
      {() => (
         <>
            <DeclarativeFields configs={internalFields} />
            <ListContainer
               {...config.fieldLayoutProps}
               name={'skills'}
               label={config.label}
               controlProps={{
                  addButtonText: config.addButtonText,
                  fields: skillFields,
                  keepAtLeastOne: config.keepAtLeastOne,
               }}
            />
            <DevFormValues open={true} />
         </>
      )}
   </Formik>
);

export const DeclarativeStory = DeclarativeTemplate.bind({});

export const ReactStory = ReactTemplate.bind({});

export default {
   args: {
      addButtonText: 'Add skill',
      keepAtLeastOne: false,
      label: 'Skills',
      preventNamePrefixing: false,
   },
   title: 'forms2/listContainers/ListContainer',
} as Meta<StoryProps>;
