import { ContainerConfig, ExtendedFieldConfig } from '../../models';

import { ListContainer, ListContainerControlProps } from './ListContainer';

export { ListContainer } from './ListContainer';

export interface ListContainerConfig<FV, V> extends ContainerConfig<FV, V> {
   addButtonText?: ListContainerControlProps['addButtonText'];
   keepAtLeastOne?: ListContainerControlProps['keepAtLeastOne'];
}

export function list<FormValue = any, V = any[]>({
   fieldLayoutProps,
   key,
   label,
   name,
   ...controlProps
}: ListContainerConfig<FormValue, V>): ExtendedFieldConfig<FormValue, V, ListContainerControlProps> {
   return {
      ...fieldLayoutProps,
      as: ListContainer,
      controlProps,
      key,
      label,
      name,
   };
}
