import { ContainerConfig, ExtendedFieldConfig } from '../../models';

import { TableContainer, TableContainerControlProps } from './TableContainer';

export { TableContainer } from './TableContainer';

export interface TableContainerConfig<FV, V> extends ContainerConfig<FV, V> {
   addButtonText?: TableContainerControlProps['addButtonText'];
   keepAtLeastOne?: TableContainerControlProps['keepAtLeastOne'];
   tableProps?: TableContainerControlProps['tableProps'];
}

export function table<FormValue = any, V = any>({
   fieldLayoutProps,
   key,
   label,
   name,
   ...controlProps
}: TableContainerConfig<FormValue, V>): ExtendedFieldConfig<FormValue, V, TableContainerControlProps> {
   return {
      ...fieldLayoutProps,
      as: TableContainer,
      controlProps,
      key,
      label,
      name,
   };
}
