import * as React from 'react';

import { ContainerControlProps, ExtendedFieldConfig } from '../../models';
import { LabelPositionWrapper } from '../LabelPositionWrapper/LabelPositionWrapper';
import { NamePrefixingWrapper } from '../NamePrefixingWrapper/NamePrefixingWrapper';

export interface ContainerWrapperProps extends ExtendedFieldConfig<any, any, ContainerControlProps> {
   className?: string;
}

/**
 * Meta-wrapper, combination of LabelPositionWrapper and NamePrefixingWrapper
 *
 * Used for simplify creation of new form containers, decreasing boilerplate code.
 */
export const ContainerWrapper: React.FC<ContainerWrapperProps> = React.memo(
   ({ className, children, controlProps = {}, name }) => {
      const { labelPosition, preventNamePrefixing } = controlProps;

      return (
         <LabelPositionWrapper className={className} position={labelPosition}>
            <NamePrefixingWrapper containerName={name} preventNamePrefixing={preventNamePrefixing}>
               {children}
            </NamePrefixingWrapper>
         </LabelPositionWrapper>
      );
   },
);

ContainerWrapper.displayName = 'ContainerWrapper';
