import * as React from 'react';
import { useContext } from 'react';

import { omitUndefinedProperties } from '../../../helpers';
import { ExtendedFieldConfig } from '../../models';
import { OverridingFieldPropsContext } from '../contexts';

export const FieldOverrideWrapper: React.FC<Partial<ExtendedFieldConfig>> = ({ children, ...props }) => {
   const parentOverrides = useContext(OverridingFieldPropsContext);

   return (
      <OverridingFieldPropsContext.Provider
         value={omitUndefinedProperties({
            ...parentOverrides,
            ...props,
         })}
      >
         {children}
      </OverridingFieldPropsContext.Provider>
   );
};

FieldOverrideWrapper.displayName = 'FieldOverrideWrapper';
