import { action } from '@storybook/addon-actions';
import { ComponentMeta, Story } from '@storybook/react';
import { Formik } from 'formik';
import * as React from 'react';

import { DevFormValues } from '../../components';
import { InputField } from '../../fields';

import { LabelPositionWrapper, LabelPositionWrapperProps } from './LabelPositionWrapper';

const Template: Story<LabelPositionWrapperProps> = props => (
   <LabelPositionWrapper {...props}>
      <Formik initialValues={{}} onSubmit={action('onSubmit')}>
         {() => (
            <>
               <InputField name={'name'} label={'Name'} />
               <InputField name={'age'} label={'Age'} controlProps={{ type: 'number' }} />
               <DevFormValues />
            </>
         )}
      </Formik>
   </LabelPositionWrapper>
);

export const Default = Template.bind({});
Default.args = {
   position: 'left',
};
Default.argTypes = {
   position: {
      control: { type: 'radio', options: ['left', 'top', undefined] },
   },
};

export default {
   component: LabelPositionWrapper,
   title: 'forms2/components/LabelPositionWrapper',
} as ComponentMeta<typeof LabelPositionWrapper>;
