import * as React from 'react';

import { classNames } from '../../../formatters';
import { LabelPosition } from '../../models';

import classes from './LabelPositionWrapper.module.css';

export interface LabelPositionWrapperProps {
   className?: string;
   position?: LabelPosition;
}

/**
 * Just applies CSS-variable for defining form layout.
 *
 * If position is undefined, behaviour will be inherited (default is 'left')
 */
export const LabelPositionWrapper: React.FC<LabelPositionWrapperProps> = ({ className, position, children }) => {
   return (
      <div
         className={classNames(classes.wrapper, className, {
            [classes.left]: position === 'left',
            [classes.top]: position === 'top',
         })}
      >
         {children}
      </div>
   );
};

LabelPositionWrapper.displayName = 'LabelPositionWrapper';
