import * as React from 'react';
import { useContext } from 'react';

import { formatName } from '../../helpers';
import { ContainerControlProps, ExtendedFieldConfig } from '../../models';
import { NamePrefixContext } from '../contexts';

export interface NamePrefixingWrapperProps {
   containerName?: ExtendedFieldConfig['name'];
   preventInheritance?: boolean;
   preventNamePrefixing?: ContainerControlProps['preventNamePrefixing'];
}

export const NamePrefixingWrapper: React.FC<NamePrefixingWrapperProps> = ({
   children,
   preventNamePrefixing,
   preventInheritance,
   containerName,
}) => {
   const parentNamePrefix = useContext(NamePrefixContext);

   if (preventNamePrefixing || !containerName) {
      return children as any;
   }

   return (
      <NamePrefixContext.Provider
         value={preventInheritance ? containerName : formatName(parentNamePrefix, containerName)}
      >
         {children}
      </NamePrefixContext.Provider>
   );
};

NamePrefixingWrapper.displayName = 'NamePrefixingWrapper';
