import { useCallback, useContext } from 'react';

import { formatName } from '../../helpers';
import { ExtendedFieldConfig } from '../../models';
import { NamePrefixContext } from '../contexts';

export function useNamePrefixer() {
   const namePrefix = useContext(NamePrefixContext);

   return useCallback((fieldName: ExtendedFieldConfig['name']) => formatName(namePrefix, fieldName), [namePrefix]);
}
