import { isClonable } from '../../_models';

const primitiveTypes = new Set([typeof '', typeof 0, typeof true, typeof undefined]);

export function deepClone<T>(obj: T): T {
   if (primitiveTypes.has(typeof obj) || obj === null) {
      return obj;
   }

   if (isClonable(obj)) {
      return obj.clone();
   }

   if (obj instanceof Array) {
      return obj.map(deepClone) as any;
   }

   if (obj instanceof Date) {
      return new Date(obj.getTime()) as any;
   }

   if (obj instanceof RegExp) {
      return new RegExp(obj) as any;
   }

   if (obj instanceof Set) {
      return new Set(deepClone(Array.from(obj))) as any;
   }

   if (obj instanceof Map) {
      const newMap = new Map();
      obj.forEach((v, k) => {
         newMap.set(deepClone(k), deepClone(v));
      });

      return newMap as any;
   }

   if (typeof obj === 'object') {
      return Object.keys(obj).reduce((acc, key) => {
         acc[key] = deepClone(obj[key]);

         return acc;
      }, {} as T);
   }

   // fallback
   console.warn('Please define clone method for ', obj);

   return JSON.parse(JSON.stringify(obj));
}
