import { isEmpty } from './isEmpty';

describe('isEmpty', () => {
   it('should be true for', () => {
      expect(isEmpty(undefined)).toBe(true);
      expect(isEmpty(null)).toBe(true);
      expect(isEmpty('')).toBe(true);
      expect(isEmpty('\t')).toBe(true);
      expect(isEmpty('  ')).toBe(true);
      expect(isEmpty('\n')).toBe(true);
      expect(isEmpty({})).toBe(true);
      expect(isEmpty([])).toBe(true);
      expect(isEmpty(new Set())).toBe(true);
      expect(isEmpty(/(?:)/)).toBe(true);
      expect(isEmpty(Number.NaN)).toBe(true);
   });

   it('should be false for', () => {
      expect(isEmpty(0)).toBe(false);
      expect(isEmpty('1')).toBe(false);
      expect(isEmpty({ x: undefined })).toBe(false);
      expect(isEmpty([1])).toBe(false);
      expect(isEmpty(new Set([1]))).toBe(false);
      expect(isEmpty(/xxx/)).toBe(false);
   });
});
