import { isEqual } from './isEqual';

export function isEmpty<T>(val: T | undefined): val is undefined {
   if (val === null) {
      return true;
   }

   switch (typeof val) {
      case 'undefined':
         return true;
      case 'boolean':
      case 'function':
         return false;
      case 'string':
         return val.trim() === '';
      case 'number':
         return Number.isNaN(val);
      default:
         break;
   }

   if (val instanceof Array) {
      return val.length === 0;
   }

   if (val instanceof Set || val instanceof Map) {
      return val.size === 0;
   }

   if (val instanceof RegExp) {
      return isEqual(val, /(?:)/);
   }

   if (val instanceof Date) {
      return val.getTime() === 0;
   }

   return isEqual(val, {});
}
