import { isEmptyOrDefault } from './isEmptyOrDefault';

describe('isEmptyOrDefault', () => {
   it('should be true for empty not object values', () => {
      expect(isEmptyOrDefault(undefined as any)).toBe(true);

      expect(isEmptyOrDefault(null as any)).toBe(true);

      expect(isEmptyOrDefault('' as any)).toBe(true);

      expect(isEmptyOrDefault([] as any)).toBe(true);

      expect(isEmptyOrDefault(new Set() as any)).toBe(true);
   });

   it('should be true for', () => {
      expect(isEmptyOrDefault({ x: 1, y: 2 }, { x: 1, y: 2 })).toBe(true);

      expect(isEmptyOrDefault({ x: '', y: [] })).toBe(true);

      expect(isEmptyOrDefault({ query: '', state: 'all' }, { state: 'all' })).toBe(true);
   });

   it('should be false for', () => {
      expect(isEmptyOrDefault({ x: 1 })).toBe(false);

      expect(isEmptyOrDefault({ query: '', state: 'dead' }, { state: 'all' })).toBe(false);

      expect(isEmptyOrDefault({ query: 'x', state: 'all' }, { state: 'all' })).toBe(false);
   });
});
