import { isEmpty } from './isEmpty';
import { isEqual } from './isEqual';

export function isEmptyOrDefault(obj: object, defaults: any = null): boolean {
   for (const field in obj) {
      if (!obj.hasOwnProperty(field)) {
         continue;
      }

      const value = obj[field];
      const defaultValue = defaults ? defaults[field] : undefined;

      if (!isEmpty(value) && !isEqual(value, defaultValue)) {
         return false;
      }
   }

   return true;
}
