/**
 * Возвращает новый массив с измененным элементом.
 *
 *
 * @param list Исходный массив
 * @param find Предикат для поиска элемента (или нескольких)
 * @param map Функция, конструирующая новый элемент на базе старого
 */
export function replaceItem<T>(list: T[], find: (i: T) => boolean, map: (old: T) => T): T[] {
   return list.map(item => (find(item) ? map(item) : item));
}
