import { sortHandler } from './sortHandler';

describe('sortHandler', () => {
   it('should work with numbers', () => {
      const input = [1, 3, 4, 7, 6, 5];
      input.sort((a, b) => sortHandler(a, b));

      expect(input).toEqual([1, 3, 4, 5, 6, 7]);
   });

   it('should work with strings', () => {
      const input = ['ivan', 'igor', 'artem', 'max', 'victor'];
      input.sort((a, b) => sortHandler(a, b));

      expect(input).toEqual(['artem', 'igor', 'ivan', 'max', 'victor']);
   });

   it('should work with objects', () => {
      const persons = [
         { name: 'ivan', age: 23 },
         { name: 'igor', age: 32 },
         { name: 'tema', age: 31 },
      ];

      persons.sort((a, b) => sortHandler(b.age, a.age)); // сортировка по возрасту, убывающая
      expect(persons).toEqual([
         { name: 'igor', age: 32 },
         { name: 'tema', age: 31 },
         { name: 'ivan', age: 23 },
      ]);

      persons.sort((a, b) => sortHandler(a.name, b.name)); // сортировка по имени, возрастающая
      expect(persons).toEqual([
         { name: 'igor', age: 32 },
         { name: 'ivan', age: 23 },
         { name: 'tema', age: 31 },
      ]);
   });
});
