import { splitBy } from './splitBy';

describe('splitBy', () => {
   const isEven = (n: number) => n % 2 === 0;

   it('should split numbers', () => {
      expect(splitBy([1, 2, 3, 4], isEven)).toEqual([
         [2, 4],
         [1, 3],
      ]);
   });

   it('should support destructuring', () => {
      const [even, odd] = splitBy([1, 2, 3, 4], isEven);

      expect(odd).toEqual([1, 3]);
      expect(even).toEqual([2, 4]);
   });
});
