export function splitBy<T>(values: T[], predicate: (o: T) => boolean): [T[], T[]] {
   const trueResult: T[] = [];
   const falseResult: T[] = [];

   for (const value of values) {
      if (predicate(value)) {
         trueResult.push(value);
      } else {
         falseResult.push(value);
      }
   }

   return [trueResult, falseResult];
}
