import { unique, uniqueBy } from './unique';

describe('unique', () => {
   it('should work without predicate', () => {
      expect(unique(['1', '2', '1', '3'])).toEqual(['1', '2', '3']);

      expect(unique([1, 2, 3, 2, 1])).toEqual([1, 2, 3]);
   });
});

describe('uniqueBy', () => {
   it('should work with predicate', () => {
      const list = [
         { x: 1, y: 2, z: 3 },
         { x: 1, y: 2, z: 4 }, // skip if x|y
         { x: 3, y: 2, z: 4 },
         { x: 1, y: 3, z: 4 }, // skip if x|z
      ];

      expect(uniqueBy(list, item => `${item.x}|${item.y}`)).toEqual([
         { x: 1, y: 2, z: 3 },
         { x: 3, y: 2, z: 4 },
         { x: 1, y: 3, z: 4 },
      ]);

      expect(uniqueBy(list, item => `${item.x}|${item.z}`)).toEqual([
         { x: 1, y: 2, z: 3 },
         { x: 1, y: 2, z: 4 },
         { x: 3, y: 2, z: 4 },
      ]);
   });
});
