// Простой вариант, подходит только для списка примитивов (строк, чисел)
export function unique<V>(values: V[]): V[] {
   return Array.from(new Set(values));
}

// Сложный вариант в вычислением "ключа"
export function uniqueBy<V, K = string>(values: V[], getKey: (v: V) => K): V[] {
   const keys = new Map<V, K>(values.map(v => [v, getKey(v)] as [V, K]));
   const result = new Map<K, V>();

   // Два словаря нужно для сохранения порядка элементов
   keys.forEach((p, v) => {
      if (!result.has(p)) {
         result.set(p, v);
      }
   });

   return Array.from(result.values());
}
