import isValid from 'date-fns/isValid';

import { parseDate } from './parseDate';

describe('parseUserDate', () => {
   it('parse incorrect date', () => {
      expect(isValid(parseDate('18.45.2018'))).toBe(false);

      expect(isValid(parseDate('xxx'))).toBe(false);
   });

   const table = [
      // Технический вариант
      { input: '2018-10-18', output: '2018-10-18' },

      // Русский вариант
      { input: '18.10.2018', output: '2018-10-18' },
      { input: '6.10.2018', output: '2018-10-06' },
      { input: '6.6.2018', output: '2018-06-06' },
      { input: '16.6.2018', output: '2018-06-16' },
      { input: '06.11.17', output: '2017-11-06' },
      { input: '6.11.17', output: '2017-11-06' },
      { input: '6.5.17', output: '2017-05-06' },
      { input: '16.5.17', output: '2017-05-16' },

      // Английский вариант
      { input: '11/15/2018', output: '2018-11-15' },
      { input: '11/15/18', output: '2018-11-15' },
      { input: '6/15/2018', output: '2018-06-15' },
      { input: '6/15/18', output: '2018-06-15' },
      { input: '6/2/18', output: '2018-06-02' },
      { input: '6/2/2018', output: '2018-06-02' },
      { input: '11/2/2018', output: '2018-11-02' },
      { input: '11/2/18', output: '2018-11-02' },
   ];

   it('parse timestamp', () => {
      expect(parseDate('1554066000')).toEqual(new Date('2019-03-31T21:00:00Z'));
   });

   for (const testCase of table) {
      // eslint-disable-next-line no-loop-func
      it(`parse ${testCase.input} to ${testCase.output}`, () => {
         expect(parseDate(testCase.input)).toEqual(new Date(`${testCase.output} 0:00:00`));
      });
   }
});
