import { fromTimestamp, toTimestamp } from './timestamps';

describe('fromTimestamp', () => {
   it('should parse ts', () => {
      expect(fromTimestamp(1542126251)).toEqual(new Date('2018-11-13T16:24:11.000Z'));
   });

   it('should skip if had been Date already', () => {
      const date = new Date('2018-11-13T16:24:11.000Z');

      expect(fromTimestamp(date)).toBe(date);
   });
});

describe('toTimestamp', () => {
   it('should convert', () => {
      expect(toTimestamp(new Date('2018-11-13T16:24:11.594Z'))).toBe(1542126252);
   });
});
