/**
 * Парсит UNIX-time (в числе СЕКУНД, не миллисекунд) в объект даты
 */
export function fromTimestamp(ts: number | Date): Date {
   return typeof ts === 'number' ? new Date(ts * 1000) : ts;
}

/**
 * Возвращает временную метку в секундах
 */
export function toTimestamp(v: Date | number): number {
   return v instanceof Date ? Math.round(v.getTime() / 1000) : v;
}
