/**
 * Самая примитивная реализация "антидребезга", которая пришла в голову
 *
 * Название чутка добавлено, чтобы не конфликтовать с декоратором @debounce
 *
 * @param func {Function} Функцию, которую нужно отложить
 * @param wait {number} Время "антидребезга" в мс
 */
// tslint:disable-next-line:ban-types
export function debounceFunc(func: Function, wait: number): (...args: any[]) => void {
   let timeout: number | null;

   return (...args: any[]) => {
      clearTimeout(timeout as any);
      timeout = setTimeout(() => {
         timeout = null;

         // @ts-ignore
         func.apply(this, args);
      }, wait) as any;
   };
}
