import React, { ReactNode } from 'react';

export function findChildren(children: ReactNode, Component: React.FC<any>) {
   function filterChildren(currentChildren: ReactNode[]) {
      const result: ReactNode[] = [];

      for (const child of currentChildren) {
         if ((child as any).type === Component) {
            result.push(child);
         }

         const grandChildren = (child as any).props?.children;
         if (grandChildren) {
            result.push(...filterChildren(React.Children.toArray(grandChildren)));
         }
      }

      return result;
   }

   return filterChildren(React.Children.toArray(children));
}
