const counters = new Map<string, number>();

/**
 * Возвращает уникальное в пределах счётчика число (и инкрементирует его)
 *
 * Полезно для выбора в e2e тестах компонентов, логически иерархических, но в разнесённых в DOM-дереве.
 * Чаще всего это popup, tooltip, dropdown, menu, modals и т.п. компоненты, привязываемые прямо к body
 */
export function getUniqueId(counter = 'global'): number {
   if (counters.has(counter)) {
      const nextId = counters.get(counter)! + 1;
      counters.set(counter, nextId);

      return nextId;
   }
   counters.set(counter, 1);

   return 1;
}
