import { round } from './round';

interface ITestCase {
   input: [number, number?];
   output: number;
}

describe('round', () => {
   const table: ITestCase[] = [
      { input: [2.3], output: 2 },
      { input: [2.000001], output: 2 },
      { input: [2.5], output: 3 },
      { input: [2.9], output: 3 },
      { input: [1111.5], output: 1112 },
      { input: [1111.5, 1], output: 1110 },
      { input: [1111.5, 2], output: 1100 },
      { input: [1111.5, 3], output: 1000 },
      { input: [2.3924, -1], output: 2.4 },
      { input: [2.3924, -2], output: 2.39 },
      { input: [2.3924, -3], output: 2.392 },
   ];

   for (const testCase of table) {
      // eslint-disable-next-line no-loop-func
      it(`should round ${testCase.input} to ${testCase.output}`, () => {
         expect(round(...testCase.input)).toBeCloseTo(testCase.output, 5);
      });
   }
});
