import { omitUndefinedProperties } from './omitUndefinedProperties';

describe('omitUndefinedProperties', () => {
   it('should omit', () => {
      expect(omitUndefinedProperties({ x: 1, y: undefined })).toEqual({ x: 1 });
   });

   it('should work with non-object', () => {
      expect(omitUndefinedProperties(1 as any)).toBe(1);

      expect(omitUndefinedProperties([1, 2, 3] as any)).toEqual([1, 2, 3]);

      expect(omitUndefinedProperties(/xx/ as any)).toEqual(/xx/);
   });
});
