export function omitUndefinedProperties<T>(obj: Partial<T>): Partial<T> {
   if (
      !obj ||
      typeof obj !== 'object' ||
      obj instanceof Array ||
      obj instanceof Set ||
      obj instanceof RegExp ||
      obj instanceof Date
   ) {
      return obj;
   }

   return Object.keys(obj).reduce((acc, key) => {
      if (obj[key] !== undefined) {
         acc[key] = obj[key];
      }

      return acc;
   }, {}) as any;
}
