import { addSetItem } from './addSetItem';

describe('addSetItem', () => {
   it('should return unchanged set if item has already existed', () => {
      const set = new Set([1, 2, 3]);

      const result = addSetItem(set, 2);

      expect(result).toBe(set);
      expect(result).toEqual(new Set([1, 2, 3]));
   });

   it('shouldn`t mutate set', () => {
      const set = new Set([1, 2, 3]);

      const result = addSetItem(set, 5);

      expect(set).toEqual(new Set([1, 2, 3]));
      expect(result).not.toBe(set);
   });

   it('should return new set with added item', () => {
      const set = new Set([1, 2, 3]);

      const result = addSetItem(set, 5);

      expect(result).toEqual(new Set([1, 2, 3, 5]));
   });
});
