/**
 * Возвращает новое множество с добавленным элементом.
 *
 * Если элемент уже есть в множестве, то ничего не делает,
 * возвращает то же множество без изменений.
 */
export function addSetItem<T>(set: Set<T>, item: T): Set<T> {
   if (set.has(item)) {
      return set;
   }

   const result = new Set(set);
   result.add(item);

   return result;
}
