import { fillSetFields } from './fillSetFields';

interface IEntity {
   a?: Set<number>;
   b?: Set<string>;
   c?: Set<RegExp>;
}

describe('fillSetFields', () => {
   it('should convert existing fields', () => {
      const item: IEntity = {
         a: [1, 2] as any,
         b: ['a', 'b'] as any,
      };

      fillSetFields(item, ['a', 'b']);

      expect(item.a).toEqual(new Set([1, 2]));
      expect(item.b).toEqual(new Set(['a', 'b']));
   });

   it('should add empty Set for not-existing fields', () => {
      const item: IEntity = {
         a: [1, 2] as any,
         b: ['a', 'b'] as any,
      };

      fillSetFields(item, ['c']);

      expect(item.c).toEqual(new Set());
   });

   it('should add empty Set for undefined fields', () => {
      const item: IEntity = {
         c: undefined,
      };

      fillSetFields(item, ['c']);

      expect(item.c).toEqual(new Set());
   });
});
