import { getSetDifference } from './getSetDifference';

describe('getSetDifference', () => {
   const oldSet = new Set(['a', 'b', 'c']);
   const newSet = new Set(['a', 'b', 'd']);

   it('should detect added items', () => {
      expect(getSetDifference(oldSet, newSet).added).toEqual(new Set(['d']));
   });

   it('should detect removed items', () => {
      expect(getSetDifference(oldSet, newSet).removed).toEqual(new Set(['c']));
   });

   it('should detect unchanged items', () => {
      expect(getSetDifference(oldSet, newSet).unchanged).toEqual(new Set(['a', 'b']));
   });
});
