interface Result<T> {
   added: Set<T>;
   removed: Set<T>;
   unchanged: Set<T>;
}

export function getSetDifference<T>(oldSet: Set<T>, newSet: Set<T>): Result<T> {
   const result: Result<T> = {
      added: new Set<T>(),
      removed: new Set<T>(),
      unchanged: new Set<T>(),
   };

   oldSet.forEach(v => {
      if (newSet.has(v)) {
         result.unchanged.add(v);
      } else {
         result.removed.add(v);
      }
   });

   newSet.forEach(v => {
      if (!oldSet.has(v)) {
         result.added.add(v);
      }
   });

   return result;
}
