import { removeSetItem } from './removeSetItem';

describe('removeSetItem', () => {
   it('should return unchanged set if item has not exist', () => {
      const set = new Set([1, 2, 3]);

      const result = removeSetItem(set, 4);

      expect(result).toBe(set);
      expect(result).toEqual(new Set([1, 2, 3]));
   });

   it('shouldn`t mutate set', () => {
      const set = new Set([1, 2, 3]);

      const result = removeSetItem(set, 3);

      expect(set).toEqual(new Set([1, 2, 3]));
      expect(result).not.toBe(set);
   });

   it('should return new set with removed item', () => {
      const set = new Set([1, 2, 3]);

      const result = removeSetItem(set, 3);

      expect(result).toEqual(new Set([1, 2]));
   });
});
