/**
 * Возвращает новое множество с удалённым элементом.
 *
 * Если элемента нет в множестве, то ничего не делает,
 * возвращает то же множество без изменений.
 */
export function removeSetItem<T>(set: Set<T>, item: T): Set<T> {
   if (!set.has(item)) {
      return set;
   }

   const result = new Set(set);
   result.delete(item);

   return result;
}
