import { toggleSetItem } from './toggleSetItem';

describe('toggleSetItem', () => {
   let set: Set<number>;
   beforeEach(() => {
      set = new Set([1, 2, 3]);
   });

   it('should add if not exists', () => {
      const newSet = toggleSetItem(set, 4);

      expect(newSet).toEqual(new Set([1, 2, 3, 4]));
   });

   it('should remove if exists', () => {
      const newSet = toggleSetItem(set, 2);

      expect(newSet).toEqual(new Set([1, 3]));
   });

   it('should be another set', () => {
      const newSet = toggleSetItem(set, 4);

      expect(newSet).not.toBe(set);
   });
});
