/**
 * Возвращает новое множество, у которого элемент переключён (исключён, если был, и добавлен, если не было)
 *
 * Имеет смысл использовать для хранения всяких флажков-переключателей (например текущего списка выделенных элементов)
 */
export function toggleSetItem<T>(set: Set<T>, item: T): Set<T> {
   const copyOfSet = new Set(set);

   if (copyOfSet.has(item)) {
      copyOfSet.delete(item);
   } else {
      copyOfSet.add(item);
   }

   return copyOfSet;
}
