import { hasIncluded } from './hasIncluded';

describe('hasIncluded', () => {
   it('should return true for lowercase values', () => {
      expect(hasIncluded('a', 'a', 'b', 'c')).toBe(true);
   });

   it('should return true for uppercase values', () => {
      expect(hasIncluded('A', 'a', 'b', 'c')).toBe(true);
      expect(hasIncluded('a', 'A', 'B', 'C')).toBe(true);
   });

   it('should return false', () => {
      expect(hasIncluded('a', 'x', 'y', 'z')).toBe(false);
      expect(hasIncluded('a')).toBe(false);
   });
});
