/**
 * Функция для удобной фильтрации значений
 *
 * К примеру, удобно для поиска сразу по нескольким полям объекта
 */
export function hasIncluded(q: string, ...values: string[]): boolean {
   const query = q.trim().toLowerCase();

   return values.map(v => v.trim().toLowerCase()).some(v => v.includes(query));
}
