import { repeat } from './repeat';

function pad(side: 'left' | 'right', text: string, length: number, char: string): string {
   if (!char) {
      char = '0';
   }

   const times = Math.ceil((length - text.length) / char.length);

   return side === 'left' ? repeat(char, times) + text : text + repeat(char, times);
}

export function leftPad(text: string, length: number, char: string): string {
   return pad('left', text, length, char);
}

export function rightPad(text: string, length: number, char: string): string {
   return pad('right', text, length, char);
}
