import { toQuery } from './toQuery';

describe('toQuery', () => {
   it('should serialize simple object', () => {
      expect(toQuery({ x: 1, y: 2 })).toBe('x=1&y=2');
   });

   it('should skip undefined', () => {
      expect(toQuery({ x: 1, y: undefined })).toBe('x=1');
   });

   it('should add null', () => {
      expect(toQuery({ x: 3, y: null })).toBe('x=3&y');
   });

   it('should serialize arrays', () => {
      expect(toQuery({ x: 3, y: ['a', 'b', 'c'] })).toBe(`x=3&y=${encodeURIComponent('a,b,c')}`);
   });

   it('should serialize sets', () => {
      expect(toQuery({ x: new Set(['a', 'b', 'c']) })).toBe(`x=${encodeURIComponent('a,b,c')}`);
   });

   it('should serialize dates', () => {
      expect(toQuery({ x: new Date('2018-11-22T00:00:00Z') })).toBe('x=1542844800');

      expect(toQuery({ x: new Date('2018-11-22T00:00:00.150Z') })).toBe('x=1542844800');

      expect(toQuery({ x: new Date('2018-11-22T00:00:00.955Z') })).toBe('x=1542844801');
   });

   it('should skip invalid dates', () => {
      expect(toQuery({ y: 2, x: new Date('bla bla') })).toBe('y=2');
   });

   it('should skip empty array or sets', () => {
      expect(toQuery({ x: 1, y: [] })).toBe('x=1');

      expect(toQuery({ x: 1, y: new Set([]) })).toBe('x=1');
   });

   it('should skip empty string', () => {
      expect(toQuery({ x: 1, y: '' })).toBe('x=1');
   });
});
