import { stringify as stringifyQuery } from 'query-string';

import { setToQueryValue } from './setToQueryValue';

export function toQuery<T>(obj: T): string {
   const normalized = Object.keys(obj).reduce((acc, key) => {
      if (obj[key] instanceof Date) {
         if (!Number.isNaN(obj[key].getTime())) {
            acc[key] = Math.round(obj[key].getTime() / 1000).toString();
         }
      } else if (obj[key] instanceof Set) {
         if (obj[key].size > 0) {
            acc[key] = setToQueryValue(obj[key]);
         }
      } else if (obj[key] instanceof Array) {
         if (obj[key].length > 0) {
            acc[key] = setToQueryValue(obj[key]);
         }
      } else if (obj[key] !== '') {
         acc[key] = obj[key];
      }

      return acc;
   }, {});

   return stringifyQuery(normalized);
}
