import { Dialog } from '@yandex-cloud/uikit';
import * as React from 'react';
import { useEffect, useState } from 'react';

import { withDismounted } from '../../utils';
import { globalHotKeys } from '../globalHotKeys';

import classes from './HotKeysHelpModal.module.css';

export function HotKeysHelpModal() {
   const [visible, setVisible] = useState(globalHotKeys.isHelpVisible());

   useEffect(() => {
      const subscription = globalHotKeys.helpObs.subscribe(() => setVisible(globalHotKeys.isHelpVisible()));

      return () => subscription.unsubscribe();
   }, []);

   return (
      <Dialog className={classes.hotKeysHelpModal} open={visible} onClose={globalHotKeys.toggleHelp} size={'s'}>
         <Dialog.Header caption={'Shortcuts'} />

         <Dialog.Body className={classes.content}>
            <ul>
               {globalHotKeys.getActiveHotKeys().map(hotKey => (
                  <li key={`${hotKey.help}:${hotKey.hotKey.code}`}>
                     <span className={classes.help}>{hotKey.help}</span>
                     <kbd className={classes.keys}>
                        {globalHotKeys.getKeyNames(hotKey).map(name => (
                           <React.Fragment key={name}>
                              <span className={classes.key}>{name}</span>
                              <span className={classes.plus}>+</span>
                           </React.Fragment>
                        ))}
                     </kbd>
                  </li>
               ))}
            </ul>
         </Dialog.Body>
      </Dialog>
   );
}

export const HotKeysHelpModalEnhanced = withDismounted(HotKeysHelpModal);
