import { storiesOf } from '@storybook/react';
import { TextInput } from '@yandex-cloud/uikit';
import * as React from 'react';
import { useEffect, useState } from 'react';

import { HotKeysHelpModalEnhanced } from './components/HotKeysHelpModal';
import { globalHotKeys } from './globalHotKeys';

function HotKeysStory() {
   // hooks
   const [value, setValue] = useState('Try to enter ? in English or , in Russian');

   // effects
   useEffect(() => {
      globalHotKeys.init();

      return globalHotKeys.register({
         hotKey: { code: 'F2' },
         action: () => console.log('F2'),
         help: 'Just F2 for tests',
      });
   }, []);

   // handlers
   const updateValue = (v: string) => setValue(v);

   // render
   return (
      <>
         <HotKeysHelpModalEnhanced />

         <TextInput value={value} onUpdate={updateValue} />
         <TextInput multiline={true} value={value} onUpdate={updateValue} rows={3} />
      </>
   );
}

storiesOf('hotkeys/Hotkeys', module).add('avoid hotkeys in fields', () => <HotKeysStory />);
