import { forkJoin, of, throwError } from 'rxjs';

import { ApiCache } from './ApiCache';

describe('http/ApiCache', () => {
   let cache: ApiCache;
   beforeEach(() => {
      cache = new ApiCache();
   });

   it('should merge simultaneous requests with same keys', done => {
      const value = { x: 11 };

      const obs1 = cache.request('key1', () => of(value));
      const obs2 = cache.request('key1', () => of(value));

      expect(obs1).toBe(obs2);

      forkJoin([obs1, obs2]).subscribe(([res1, res2]) => {
         expect(res1).toBe(res2);
         expect(res1).toBe(value);

         done();
      });
   });

   it('should remove record from cache if failed', done => {
      // first is failed
      const obs1 = cache.request('key1', () => throwError('fake error'));
      obs1.subscribe({ error: err => console.log(err) });

      // second is successful
      const value = { x: 11 };
      const obs2 = cache.request('key1', () => of(value));

      obs2.subscribe({
         error: done,
         next(v) {
            expect(v).toBe(value);
            done();
         },
      });
   });
});
