import { Observable, of } from 'rxjs';
import { finalize, tap } from 'rxjs/operators';

import { CacheStore } from './models';

export class ApiCache {
   private currentRequests: Map<string, Observable<any>> = new Map();

   constructor(private store: CacheStore = new Map<string, any>()) {}

   public request<T>(key: string, requester: () => Observable<T>): Observable<T> {
      // Успешный запрос в кеше
      if (this.store.has(key)) {
         return of<T>(this.store.get(key));
      }

      // Планирование запроса
      if (!this.currentRequests.has(key)) {
         const request = requester().pipe(
            tap((resp: T) => {
               this.store.set(key, resp);
            }),
            finalize(() => this.currentRequests.delete(key)),
         );
         this.currentRequests.set(key, request);
      }

      return this.currentRequests.get(key)!;
   }
}
