// noinspection JSUnusedGlobalSymbols
export enum HttpMethod {
   GET = 'GET',
   POST = 'POST',
   PUT = 'PUT',
   PATCH = 'PATCH',
   DELETE = 'DELETE',
}

// noinspection JSUnusedGlobalSymbols
export enum HttpStatusCode {
   NoConnection = 0,
   Continue = 100,
   SwitchingProtocols = 101,
   Processing = 102,
   Ok = 200,
   Created = 201,
   Accepted = 202,
   NonAuthoritativeInformation = 203,
   NoContent = 204,
   ResetContent = 205,
   PartialContent = 206,
   MultiStatus = 207,
   MultipleChoices = 300,
   MovedPermanently = 301,
   MovedTemporarily = 302,
   SeeOther = 303,
   NotModified = 304,
   UseProxy = 305,
   TemporaryRedirect = 307,
   PermanentRedirect = 308,
   BadRequest = 400,
   Unauthorized = 401,
   PaymentRequired = 402,
   Forbidden = 403,
   NotFound = 404,
   MethodNotAllowed = 405,
   NotAcceptable = 406,
   ProxyAuthenticationRequired = 407,
   RequestTimeout = 408,
   Conflict = 409,
   Gone = 410,
   LengthRequired = 411,
   PreconditionFailed = 412,
   RequestTooLong = 413,
   RequestUriTooLong = 414,
   UnsupportedMediaType = 415,
   RequestedRangeNotSatisfiable = 416,
   ExpectationFailed = 417,
   ImATeapot = 418,
   InsufficientSpaceOnResource = 419,
   MethodFailure = 420,
   UnprocessableEntity = 422,
   Locked = 423,
   FailedDependency = 424,
   PreconditionRequired = 428,
   TooManyRequests = 429,
   RequestHeaderFieldsTooLarge = 431,
   InternalServerError = 500,
   NotImplemented = 501,
   BadGateway = 502,
   ServiceUnavailable = 503,
   GatewayTimeout = 504,
   HttpVersionNotSupported = 505,
   InsufficientStorage = 507,
   NetworkAuthenticationRequired = 511,
}

export interface IApiError {
   errorMessage: string;
}

export function parseApiError(error: string | IApiError): string {
   const apiError = error as IApiError & { message: string };

   let errorMessage: string;

   if (typeof error === 'string') {
      errorMessage = error as string;
   } else if (error && 'errorMessage' in apiError) {
      errorMessage = apiError.errorMessage;
   } else if (error && 'message' in apiError) {
      errorMessage = apiError.message;
   } else {
      errorMessage = error.toString();
   }

   return errorMessage;
}

export interface CacheStore {
   has(key: string): boolean;

   get(key: string): any;

   set(key: string, value: any): void;
}
