import React, { ReactNode } from 'react';

import { classNames } from '../../../formatters';
import { ButtonLink } from '../../../small_components';

import { EmptyContainerDescription } from './__description/EmptyContainerDescription';
import { EmptyContainerPicture } from './__picture/EmptyContainerPicture';
import classes from './EmptyContainer.module.css';
import { EmptyContainerAction, EmptyContainerType } from './models';

interface Props {
   action?: EmptyContainerAction;
   className?: string;
   description?: string | ReactNode;
   title?: string;
   type: EmptyContainerType;
}

export const EmptyContainer = React.memo(({ action, className, description, title, type }: Props) => (
   <div className={classNames(classes.wrapper, className)} data-test={'EmptyContainer'}>
      <div className={classes.image}>
         <EmptyContainerPicture type={type} />
      </div>

      <div className={classes.content} data-test={'EmptyContainer:Content'}>
         {title ? (
            <h2 className={classes.title} data-test={'EmptyContainer:Title'}>
               {title}
            </h2>
         ) : null}

         {description ? (
            <div className={classes.description} data-test={'EmptyContainer:Description'}>
               <EmptyContainerDescription description={description} />
            </div>
         ) : null}

         {action?.text && action?.link ? (
            <div className={classes.action} data-test={'EmptyContainer:Action'}>
               <ButtonLink to={action.link} view={'action'}>
                  {action.text}
               </ButtonLink>
            </div>
         ) : null}
      </div>
   </div>
));

EmptyContainer.displayName = 'EmptyContainer';
